unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Label1: TLabel;
    Edit2: TEdit;
    Label2: TLabel;
    Edit3: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Edit4: TEdit;
    Edit5: TEdit;
    Label5: TLabel;
    Edit6: TEdit;
    Label6: TLabel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    NumerPrezentowanegoRekordu :Integer;
    procedure PrezentujRekord;
  public
    { Public declarations }
  end;

type
  TPracownik = record
    Imie,Nazwisko :String;
    KodStanowiska :Byte;
    Pensja,FunduszPracowniczy :Currency;
    PremiaProcent :Byte;
  end;

  TMiesiac = (mStyczen=1, mLuty, mMarzec, mKwiecien, mMaj, mCzerwiec, mLipiec, mSierpien, mWrzesien, mPazdziernik, mListopad, mGrudzien);
  TData = record
    Dzien :1..31;
    Miesiac :TMiesiac;
    Rok :Cardinal;
  end;

var
  Form1: TForm1;
  Pracownicy: array of TPracownik;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var l :Cardinal;
begin
if (Edit1.Text<>'') and (Edit2.Text<>'') and (Edit3.Text<>'') and (Edit4.Text<>'')
  then
    begin
    l:=Length(Pracownicy);
    SetLength(Pracownicy,l+1);
    with Pracownicy[l] do
      begin
      Imie:=Edit1.Text;
      Nazwisko:=Edit2.Text;
      KodStanowiska:=StrToInt(Edit3.Text);
      Pensja:=StrToInt(Edit4.Text);
      FunduszPracowniczy:=StrToInt(Edit5.Text);
      PremiaProcent:=StrToInt(Edit6.Text);
      end;
    Caption:='Liczba pracownikw: '+IntToStr(Length(Pracownicy));
    ShowMessage('Do listy pracownikw dodaem rekord nr '+IntToStr(l));
    Edit1.Text:=''; Edit2.Text:='';
    Edit3.Text:='0';
    Edit4.Text:='0'; Edit5.Text:='0'; Edit6.Text:='0';
    NumerPrezentowanegoRekordu:=-1;
    end
  else ShowMessage('Naley wypeni wszystkie oznaczone pola');
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  Pracownik :TPracownik;
  s :String;
begin
s:='Lista pracownikw: '+#13;
for Pracownik in Pracownicy do s:=s+Pracownik.Imie+' '+Pracownik.Nazwisko+
                                  ' ('+IntToStr(Pracownik.KodStanowiska)+')'+#13;
s:=s+#13+'Liczba rekordw: '+IntToStr(Length(Pracownicy));
ShowMessage(s);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
if NumerPrezentowanegoRekordu>0 then Dec(NumerPrezentowanegoRekordu);
PrezentujRekord;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
if NumerPrezentowanegoRekordu<Length(Pracownicy)-1 then Inc(NumerPrezentowanegoRekordu);
PrezentujRekord;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
NumerPrezentowanegoRekordu:=-1;
end;

procedure TForm1.PrezentujRekord;
begin
if NumerPrezentowanegoRekordu=-1 then Exit;
Caption:='Dane pracownika nr '+IntToStr(NumerPrezentowanegoRekordu);
with Pracownicy[NumerPrezentowanegoRekordu] do
  begin
  Edit1.Text:=Imie;
  Edit2.Text:=Nazwisko;
  Edit3.Text:=IntToStr(KodStanowiska);
  Edit4.Text:=CurrToStr(Pensja);
  Edit5.Text:=CurrToStr(FunduszPracowniczy);
  Edit6.Text:=IntToStr(PremiaProcent);
  end;
end;

end.
